package com.ejie.aa17a.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.Aa17aContaminanteDao;
import com.ejie.aa17a.model.Aa17aContaminante;

/**
 * Aa17aContaminanteDaoImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

@Transactional
public class Aa17aContaminanteDaoImpl implements Aa17aContaminanteDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Aa17aContaminante> rwMap = new RowMapper<Aa17aContaminante>() {
		public Aa17aContaminante mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Locale locale = LocaleContextHolder.getLocale();
			Aa17aContaminante contaminante = new Aa17aContaminante();

			contaminante.setIdContaminante(resultSet.getLong("IDCONTAMINANTE"));
			contaminante.setCodContaminante(resultSet.getString("CODCONTAMINANTE"));
			contaminante.setNombreContaminante(resultSet.getString("NOMBRECONTAMINANTE"));
			contaminante.setUnidadMedida(resultSet.getString("UNIDADMEDIDA"));

			if (resultSet.getTimestamp("FECHABAJA") != null) {
				contaminante.setFechaBaja(new Date(resultSet.getTimestamp("FECHABAJA").getTime()));
			}

			if (com.ejie.x38.util.Constants.EUSKARA.equals(locale.getLanguage())) {
				contaminante.setDescripcion(resultSet.getString("DESC_EU"));
			}
			else {
				contaminante.setDescripcion(resultSet.getString("DESC_ES"));
			}

			return contaminante;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the Aa17aContaminante table.
	 * 
	 * @param aa17acontaminante
	 *            Pagination
	 * @return Aa17aContaminante
	 */
	@Transactional(readOnly = true)
	public Aa17aContaminante find(Aa17aContaminante aa17acontaminante) {

		StringBuilder query = new StringBuilder();

		query.append("SELECT  t1.T02_CONTAMINANTE_ID IDCONTAMINANTE,");
		query.append(" t1.T02_COD_CONTAMINANTE CODCONTAMINANTE, t1.T02_NOMBRE NOMBRECONTAMINANTE, ");
		query.append(" t1.T02_UNIDAD_MEDIDA UNIDADMEDIDA, t1.T02_FECHA_BAJA FECHABAJA, ");
		query.append(" t1.T02_DESC_ES DESC_ES, t1.T02_DESC_EU DESC_EU ");
		query.append(" FROM AA1702S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17acontaminante);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		List<Aa17aContaminante> aa17acontaminanteList = this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
		return (Aa17aContaminante) DataAccessUtils.uniqueResult(aa17acontaminanteList);
	}

	/**
	 * Finds a List of rows in the Aa17aContaminante table.
	 * 
	 * @param aa17acontaminante
	 *            Aa17aContaminante
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aa17aContaminante> findAll(Aa17aContaminante aa17acontaminante) {
		StringBuilder query = new StringBuilder();
		query.append("SELECT  t1.T02_CONTAMINANTE_ID IDCONTAMINANTE,");
		query.append(" t1.T02_COD_CONTAMINANTE CODCONTAMINANTE, t1.T02_NOMBRE NOMBRECONTAMINANTE, ");
		query.append(" t1.T02_UNIDAD_MEDIDA UNIDADMEDIDA, t1.T02_FECHA_BAJA FECHABAJA, ");
		query.append(" t1.T02_DESC_ES DESC_ES, t1.T02_DESC_EU DESC_EU ");
		query.append(" FROM AA1702S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17acontaminante);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Aa17aContaminante>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa17aContaminante entity
	 * 
	 * @param aa17acontaminante
	 *            Aa17aContaminante Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa17aContaminante aa17acontaminante) {

		StringBuffer where = new StringBuffer(
				Aa17aContaminanteDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa17acontaminante != null
				&& aa17acontaminante.getIdContaminante() != null) {
			where.append(" AND t1.T02_CONTAMINANTE_ID = ?");
			params.add(aa17acontaminante.getIdContaminante());
		}
		if (aa17acontaminante != null
				&& aa17acontaminante.getCodContaminante() != null) {
			where.append(" AND t1.T02_COD_CONTAMINANTE = ?");
			params.add(aa17acontaminante.getCodContaminante());
		}
		if (aa17acontaminante != null
				&& aa17acontaminante.getNombreContaminante() != null) {
			where.append(" AND t1.T02_NOMBRE = ?");
			params.add(aa17acontaminante.getNombreContaminante());
		}
		if (aa17acontaminante != null
				&& aa17acontaminante.getUnidadMedida() != null) {
			where.append(" AND t1.T02_UNIDAD_MEDIDA = ?");
			params.add(aa17acontaminante.getUnidadMedida());
		}
		if (aa17acontaminante != null
				&& aa17acontaminante.getFechaBaja() != null) {
			where.append(" AND t1.T02_FECHA_BAJA = ?");
			params.add(aa17acontaminante.getFechaBaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
